import java.net.*;
import java.io.*;

public class ShowDilbert {
	public static void main(String [] args){
		try
		{
			System.out.println("Getting www.dilbert.com");
			URL url=new URL("http://www.dilbert.com");
			URLConnection conn=url.openConnection();
			InputStream is=conn.getInputStream();
			LineNumberReader r=new LineNumberReader(new InputStreamReader(is));
			while(true){
				String line=r.readLine();
				if(line==null) break;
				if (parseLine(line)) break;
			}
		}
		catch(Exception e){
			e.printStackTrace();
		}
	}	
	
	public static boolean parseLine(String line) throws Exception{
		int start=line.indexOf("comics/dilbert/archive/images/dilbert");
		if(start == -1) return false;
		System.out.println("Parsing line:"+line);
		int amp=line.indexOf("&",start);
		int end=line.indexOf("\"",start);
		if(amp<end) end=amp;
		String url=line.substring(start,end);
		System.out.println("Image url:"+url);
		showImage("http://www.dilbert.com/"+url);
		return true;
	}
	
	public static void showImage(String inurl) throws Exception{
		new ImView(inurl);

	}
	
	

	
}
