import java.io.*;
import java.awt.*;
import javax.swing.*;
import com.sun.jimi.core.*;
import com.sun.jimi.core.raster.*;

public class ImResize
{
	String outdir;
	int maxdim;
	
	public static void main(String [] args){
		if(args.length<3){
			System.out.println("Usage: java ImResize outputdir maxdim images");
			System.exit(0);
		}
		ImResize me=new ImResize(args[0],args[1]);
		for(int x=2;x<args.length;x++){
			System.out.println("Resizing "+args[x]);
			me.resize(args[x]);
		}
		System.exit(0);
		
	}
	
	public ImResize(String outdir, String maxdim)
		throws IllegalArgumentException
	{
		if (!new File(outdir).isDirectory()){
			throw new IllegalArgumentException("Output directory '"+outdir+"' does not exist");
		}
		this.outdir=outdir;
		try
		{
			this.maxdim=Integer.parseInt(maxdim);
		}
		catch(NumberFormatException e){
			throw new IllegalArgumentException("Maxdim '"+maxdim+"' is not an integer");
		}
	}
	
	public void resize(String input)
	{
		String output=outdir+File.separator+input;
		
		writeWithResizeMediaTracker(input,output);
	}
	
	public void writeWithResizeMediaTracker(String input, String output)
	{
		try
		{
			Image inImage = new ImageIcon(input).getImage();
			System.out.println("Original size:"+inImage.getWidth(null)+"x"+inImage.getHeight(null));
			//
			double scale = (double) maxdim / (double) inImage.getHeight(null);
			if (inImage.getWidth(null) > inImage.getHeight(null))
			{
				scale = (double) maxdim / (double) inImage.getWidth(null);
			}
			// Determine size of new image.
			//One of them
			// should equal maxdim.
			int scaledW = (int) (scale * inImage.getWidth(null));
			int scaledH = (int) (scale * inImage.getHeight(null));
	
			//
			//
			System.out.println(">> " 
				+ inImage.getSource().getClass() 
				+ " aspect ratio = " 
				+ scaledW + " , " + scaledH);
			Image img = inImage.getScaledInstance(scaledW , scaledH, Image.SCALE_SMOOTH);
			File outputFile = new File(output);
			outputFile.delete();
			JimiRasterImage raster = Jimi.createRasterImage(img.getSource());
			FileOutputStream fos = new FileOutputStream(outputFile);
			Jimi.putImage("image/jpeg", raster, fos);
			fos.flush();
			fos.close();
		}
		catch (Throwable t)
		{
			t.printStackTrace();
		}
	}

	
}
