import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import com.sun.jimi.core.*;
import com.sun.jimi.core.raster.*;

public class ScaledView extends Frame implements KeyListener
{
	String outdir;
	int maxdim;
	Image image;
	Image inImage;
	int width;
	int height;
		
	public static void main(String [] args){
		if(args.length<1){
			System.out.println("Usage: java ScaledView image");
			System.exit(0);
		}
		ScaledView me=new ScaledView();
		me.view(args[0]);
	
		
	}
	
	public ScaledView()
	{
		super();
		addWindowListener(new WindowAdapter() {
    		public void windowClosing(WindowEvent e) {
      		System.exit(0);
    		}
		});
		addKeyListener(this);
	}
	
	
	public void view(String input)
	{
		try
		{
			inImage = new ImageIcon(input).getImage();			
			// Get the size of the default screen
    	Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();

			
			double yscale = (double) dim.getHeight() / (double) inImage.getHeight(null);
			double xscale = (double) dim.getWidth() / (double) inImage.getWidth(null);
			
			double scale=(yscale>xscale)?xscale:yscale;
	
			if(scale<1)
			{
				// Determine size of new image.
				width = (int) (scale * inImage.getWidth(null));
				height = (int) (scale * inImage.getHeight(null));
		
				resize();
			}
			else
			{
				image=inImage;
				width=inImage.getWidth(null);
				height=inImage.getHeight(null);
			}
			/*
			File outputFile = new File(output);
			outputFile.delete();
			JimiRasterImage raster = Jimi.createRasterImage(img.getSource());
			FileOutputStream fos = new FileOutputStream(outputFile);
			Jimi.putImage("image/jpeg", raster, fos);
			fos.flush();
			fos.close();
			*/
			
			loadImage();
			setTitle(input);
			show();
		
		}
		catch (Throwable t)
		{
			t.printStackTrace();
		}
	}
	
	public void scale(double factor){
		
		width = (int) (factor * image.getWidth(null));
		height = (int) (factor * image.getHeight(null));
		resize();
	}
	
	public void resize(){
		image = inImage.getScaledInstance(width , height, Image.SCALE_SMOOTH);
		loadImage();
	}
	
	public void paint(Graphics graphics) {
		if(image!=null)
			graphics.drawImage(image, 0, 20, null);
	}
	
	public void loadImage(){
		MediaTracker mediaTracker = new MediaTracker(this);
		mediaTracker.addImage(image, 0);
		try
		{
			mediaTracker.waitForID(0);
		}
		catch (InterruptedException ie)
		{
			System.err.println(ie);
			System.exit(1);
		}
		setSize(width,height+20);
		repaint();
	}
	
	// KeyListener methods
	public void keyPressed(KeyEvent e) {}
	public void keyReleased(KeyEvent e) {}
 	public void keyTyped(KeyEvent e) {
 		char c=e.getKeyChar();
 		System.out.println("Pressed key:"+c);
 		switch(c){
 			case ('+'):
 				scale(1.1);
 				break;
 			case('-'):
 				scale(0.9);
 				break;
 			case('q'):
 				System.exit(0);
 		}
 	}
 	


	
}