import java.awt.*;
import java.awt.event.*;
import java.io.*;

public class JBiff extends Frame implements Runnable
{
	String server;
	String user;
	String pass;
	boolean debug=false;
	Button count=new Button("Wait ...");
	boolean running=true;
	int delay=60;
	
	Dialog readbox;
	TextArea readtext;
	
	int msgnum=0;	
	
		
	public static void main(String [] args){
		try{
			new JBiff(args[0],args[1],args[2],Integer.parseInt(args[3]));
		}catch(Exception e){	
			System.out.println("Usages: JBiff server user pass delay");
			System.out.println("Delay in secs between checking");
			System.exit(0);
		}
	}
	
	public JBiff(String server, String user,String pass, int delay){
		super("JBiff");
		this.server=server;
		this.user=user;
		this.pass=pass;
		this.delay=delay;
		
		this.setLayout(new BorderLayout());
		this.add(count);
		
		
		this.addWindowListener(new WindowAdapter(){
			public void windowClosing(WindowEvent e){
				close();
			}
		});
		
		count.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){	
				launch();
			}
		});
			
		this.pack();
		this.show	();
		new Thread(this).start();
	}
	
	public void run(){
		while(running==true)
		{
			countMessages();
			try{
				Thread.sleep(delay*1000);
				
			}catch(InterruptedException e){}
			
		}
	}
		
	public synchronized int countMessages(){
		
		checkMail checker=null;
		int num=-1;
		try{
			checker=new checkMail(server,user,pass,debug);
			num=checker.getMessageCount();
			
		
		}catch(Exception e){
			e.printStackTrace();
		}
		finally{
			try{
				checker.quit();
			}catch(Exception e2){}
		}
		if(num!=-1){
			showcount(num);
		}
		
		return num;
	}
	
	public void showcount(int num)
	{
		if(num==0||num<msgnum) msgnum=0;
		else num -= msgnum;
		count.setLabel(""+num+" messages");
		
		
		repaint();
	}
	
	

	
	public void hideReadbox(){
		readtext.setText("");
		readbox.setVisible(false);
	}
	
	public void setupReadFrame(){
		readbox=new Dialog(this,"JBiff Mail Reader");
		readtext=new TextArea(40,80);
		readtext.setEditable(false);
		readbox.setLayout(new BorderLayout());
		readbox.add(readtext);
		readbox.addWindowListener(new WindowAdapter(){
			public void windowClosing(WindowEvent e){
				hideReadbox();
			}
		});
		
		readtext.addKeyListener(new KeyListener()
		{
			public void keyPressed(KeyEvent e) {}
			public void keyReleased(KeyEvent e) {}
			public void keyTyped(KeyEvent e) {
				char ch=e.getKeyChar();
				switch (ch){
					case 'r':
						msgnum=0;
						// fall through
						
					case 'n':
						showMessages();
						break;
						
					case 'p':
						prevMessage();
						break;
						
					case 'q':
						hideReadbox();
						break;
						
					case 'Q':
						close();
						break;
						
					case 'd':
						delMessage();
						break;
						
					case 'h':
						showHelp();
						break;
						
					case 'f':
						firstMessage();
						break;
						
					case 'l':
						listMessages();
						break;
						
					case '1':
					case '2':
					case '3':
					case '4':
					case '5':
					case '6':
					case '7':
					case '8':
					case '9':
						gotoMessage(ch);
						break;
						
				}
			}
		});
		readbox.pack();
	}
	
	
	
	public void showHelp(){
		String help="Key Bindings:\n\n"
		+" n - Next message\n"
		+" p - Previous message\n"
		+" f - First message\n"
		+" q - Close this window\n"
		+" Q - Quit JBiff\n"
		+" l - List messages\n"
		+" h - Show this help\n"
		+" 1-9 - Show numbered message\n";
		readtext.setText(help);
		readtext.setVisible(true);
	}
	
	public void firstMessage(){
		msgnum=0;
		showMessages();
	}
	
	public synchronized void listMessages(){
		readtext.setVisible(true);
		readtext.setText("Getting message list...");
		StringBuffer text=new StringBuffer("Messages\n\n");
		checkMail checker=null;
		try{
			checker=new checkMail(server,user,pass,debug);
			int num=checker.getMessageCount();
			for(int x=1;x<=num;x++){
				java.util.HashMap hdr=checker.getHeaders(x);
				if(x==msgnum){
					text.append(">");
				}else{
					text.append(" ");
				}
				text.append(x);
				text.append(") ");
				text.append(hdr.get("Subject"));
				text.append(" from ");
				text.append(hdr.get("From"));
				text.append("\n");
			}
			readtext.setText(text.toString());
		}catch(Exception e){
			e.printStackTrace();
		}
		finally{
			try{
				checker.quit();
			}catch(Exception e) {}
			
		}
	}
	
	public synchronized void delMessage(){
		int num=-1;
		readbox.show();
		readtext.setText("Looking for message "+msgnum);
		checkMail checker=null;
		try{
			checker=new checkMail(server,user,pass,debug);
			num=checker.getMessageCount();
			if(num>=msgnum && msgnum>0){
				readbox.show();
				readtext.setText("Deleting message "+msgnum);
				checker.deleteMessage(msgnum);
				msgnum--;
			}else{
				readtext.setText("No such message - only "+num+" messages");
			}
			
		}catch(Exception e){
			e.printStackTrace();
		}
		finally{
			try{
				checker.quit();
			}catch(Exception e) {}
			
		}
	}
	
	public void prevMessage(){
		if(msgnum>1){
			msgnum-=2;
			showMessages();
		}
		
	}
	
	public void gotoMessage(char ch){
		if(!Character.isDigit(ch)){
			return;
		}
		try
		{
			msgnum=Integer.parseInt(""+ch);
			msgnum--;
			showMessages();
		}catch(NumberFormatException e){
			// never mind
		}
	}
	
	public synchronized void showMessages(){
		
		if(readbox==null){
			setupReadFrame();
		}
		
		int msg=msgnum+1;
		int num=-1;
		readbox.show();
		readtext.setText("Looking for message "+msg);
		checkMail checker=null;
		try{
			checker=new checkMail(server,user,pass,debug);
			num=checker.getMessageCount();
			if(num>=msg && msg>0){
				readbox.show();
				readtext.setText("Retrieving message "+msg);
				readtext.setText(checker.getMessage(msg));
				
				msgnum=msg;
			}else{
				readtext.setText("No such message - only "+num+" messages");
			}
			
		}catch(Exception e){
			e.printStackTrace();
		}
		finally{
			try{
				checker.quit();
			}catch(Exception e) {}
			
		}
		
		if(num!=-1) showcount(num);
		
			
	}
	
	public void close(){
		
		running=false;
		// wake up the thread
		/*
		synchronized(this)
		{
			this.notifyAll();
		}
		*/
		System.exit(0);
		
	}
	
	public void launch(){
		
		
		/*
		JMail mail=new JMail(server,user,pass);
		mail.pack();
		mail.show();
		System.out.println(mail);
	*/
		showMessages();
	}
}
