import java.awt.*;
import java.awt.event.*;
import java.io.*;

class JMail extends Frame
{
	checkMail mailer=null;
	List index;
	Panel buttonPanel;
	Button read;
	Button del;
	Button next;
	Button prev;
	Button refresh;
	Button quit;
	TextArea view;
	String server;
	String user;
	String pass;
	int msgcnt=0;
	public boolean reallyquit=false;
	
	public static void main(String [] s){
		  if(s.length<3){
        System.err.println("Usage: printMail server user pass [delete]");
        System.exit(0);
      }
      try{
	      JMail me = new JMail(s[0],s[1],s[2]);
	      me.reallyquit=true;
	    }catch(IOException e){
	    	System.err.println("Could not initialise server");
	    	e.printStackTrace();
	    }
	}
	
	public JMail(String server,String user, String pass) throws IOException
	{
		super("JMail");
		
		this.server=server;
		this.user=user;
		this.pass=pass;
		this.addWindowListener(new WindowAdapter(){
			public void windowClosing(WindowEvent e){
				quit();
			}
		});
		
		// set up buttons
		quit=new Button("Quit");
		quit.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				quit();
			}
		});
		
		
		read=new Button("Read");
		read.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				readMsg(0);
			}
		});
		
		
		refresh=new Button("Refresh");
		refresh.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				try{
					refresh();
				}catch(IOException err){
					System.out.println("Refresh failed");
				}
			}
		});
		
		
		next=new Button("Next");
		next.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				readMsg(1);
			}
		});
		
		prev=new Button("Prev");
		prev.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				readMsg(-1);
			}
		});
		
		del=new Button("Delete");
		del.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				delMsg();
			}
		});
		
		buttonPanel=new Panel();
		buttonPanel.add(read);
		buttonPanel.add(next);
		buttonPanel.add(prev);
		buttonPanel.add(del);
		buttonPanel.add(refresh);
		buttonPanel.add(quit);
		
		index=new List(5);
    
    view=new TextArea(30,30);
    
    this.setLayout(new BorderLayout());
    this.add(index,BorderLayout.NORTH);
    
    this.add(view, BorderLayout.CENTER);
    
    this.add(buttonPanel,BorderLayout.SOUTH);
    
    this.pack();
    this.show();
    
    // get the messages
    refresh();
	}
	
	public void quit(){
		if(mailer!=null){
			try{
				mailer.quit();
			}catch(IOException e){}
		}
		this.dispose();
		if(reallyquit==true){
			System.exit(0);
		}
	}
	
	
	public void readMsg(int offset){
		int msgnum=index.getSelectedIndex();
		
		msgnum++;
		msgnum+=offset;
		
		System.out.println("Getting message "+msgnum);
		if(msgnum>msgcnt || msgnum<1){
			System.out.println("Message out of bounds");
			return;
		}
		
		index.select(msgnum-1);
		try{
			view.setText(mailer.getMessage(msgnum));
		}catch(IOException e){
			e.printStackTrace();
		}
		
	}
	
	public void delMsg(){
		int msgnum=index.getSelectedIndex();
		
		msgnum++;
		try{
			mailer.deleteMessage(msgnum);
			index.replaceItem("DELETED",msgnum-1);
		}catch(IOException e){
			e.printStackTrace();
		}
	}
	
	public void refresh() throws IOException{
		if(mailer!=null){
			mailer.quit();
		}
		index.removeAll();
				
		mailer=new checkMail(server,user,pass,true);
		msgcnt=mailer.getMessageCount();
		for(int x=1;x<=msgcnt;x++){
			java.util.HashMap map=mailer.getHeaders(x);
			String from=(String)map.get("From");
      String subj=(String)map.get("Subject");
      
      if(from==null) from="?";
      if(subj==null) subj="";
      
      index.add(subj+" from "+from);
    }
	}
	
}