import java.net.*;
import java.io.*;
import java.util.*;

public class checkMail {
  private Socket sock;
  private BufferedReader in;
  private BufferedWriter out;
  private boolean debug;
		final long MAXMESSAGELENGTH=100*1024;
    
  public checkMail(String server, String user, String pass, boolean isDebug)
  {
    debug=isDebug;
    try
    {
      sock = new Socket(server, 110);
      in  = new BufferedReader(
        new InputStreamReader(sock.getInputStream()));
      out = new BufferedWriter(
        new OutputStreamWriter(sock.getOutputStream()));

      receive();
      send("USER " + user);
      receive();
      send("PASS " + pass);
      receive();
        
    }
    catch(Exception e)
    {
      // this would be bad
      e.printStackTrace();
    }
  }

  public static void main(String s[]) {
    //
    //  checkMail [mailServer] [user] [password]
    //
    try {
      if(s.length<3){
      	System.out.println("Usage: java checkMail server user password");
      	System.exit(0);
      }
      checkMail mailer = new checkMail(s[0],s[1],s[2],false);
      
      int i=mailer.getMessageCount();
      if (i==0) {
        System.out.println("No mail waiting.");
      }
      else {
        System.out.println 
         ("There " + (i==1?"is " :"are ") + i +
          " message" +(i==1?"":"s")+ " waiting.");
          
        MSGLOOP:
         for(int x=1;x<=i;x++){
           System.out.println("Message "+x+" of "+i);
           HashMap map=mailer.getHeaders(x);
           String from=(String)map.get("From");
           String subj=(String)map.get("Subject");
           String dat=(String)map.get("Date");
           System.out.println("From:"+((from==null)?"":from));
           System.out.println("Subject:"+((subj==null)?"":subj));
           System.out.println("Date:"+((dat==null)?"":dat));
           
           
           WHILELOOP:
           while(true){
            String ans=input ("View/Del/Next/Quit?");
            if(ans.length()==0) continue;
            ans=ans.toLowerCase();
            char ch=ans.charAt(0);
            switch(ch)
            {
              case 'v':
                mailer.printMessage(x,20);
                break;

              case 'd':
                mailer.deleteMessage(x);
                break WHILELOOP;

              case 'n':
                break WHILELOOP;

              case 'q':
                break MSGLOOP;
            }
           }
        }
      }
      mailer.quit();
        
    }
    catch (Exception e) {
      e.printStackTrace();
      }
    }

  private void send(String s) throws IOException {
    if(debug)
    {
        System.err.println("Sent:"+s);
    }
    out.write(s+"\r\n");
    out.flush();
  }

  private String receive() throws IOException {
    String line = null;
    /*
    if(!in.ready()) {
    	// wait a second for a response
    	try{
	    	Thread.sleep(1000);
	    }catch (InterruptedException e){}
    }
    if(in.ready()) line = in.readLine();
    */
    line=in.readLine();
    if(debug)
    {
      System.err.println("Recieved:"+line);
    }
    return line;
  }

  public int getMessageCount() throws IOException {
    int i = 0;
    String s;

    send( "LIST");
    receive();
    while((s = receive()) != null) {

       if (!(s.equals("."))) {
         i++;
         }
       else
         return i;
       }
    return 0;
  }

  public void quit() throws IOException
  {
    send("QUIT");
    receive();
  }
 

  public HashMap getHeaders(int num) throws IOException {
    HashMap hdr=new HashMap();
    String s;
    send("TOP "+num+" 0");
    int i=0;
    while((s = receive()) != null) {
      
      if (s.equals(".")) {
        break;
      }
      StringTokenizer strtok=new StringTokenizer(s,":");
      String key=null;
      String val=null;
      if(strtok.hasMoreTokens()) {
        key=strtok.nextToken();
        key.trim();
      }
      if(strtok.hasMoreTokens()){
        val=strtok.nextToken();
        val.trim();
      }
      if(key!=null)
      {
        hdr.put(key,val);
      }

      i++;
      //if(i>200) break;
    }
    return hdr;
    
  }


  public void printMessage(int num,int page) throws IOException {
    
    String s;
	
    send("RETR "+num);
    int i=0;
    boolean skip=false;
    while( ( (s = receive()) != null) && !s.equals("")){
    	// skip headers
    }
    while((s = receive()) != null) {
      
      if (s.equals(".")) {
        break;
      }
      if(skip) continue;
      System.out.println(s);
      i++;
      if(i==page)
      {
        String str=input("(More [c to quit])");
        if(str.startsWith("c"))
        {
          // skip the rest
          skip=true;
        }
        i=0;
      }
    }
    
  }

  public String getMessage(int num) throws IOException {
    
    String s;
	StringBuffer buf = new StringBuffer();
    send("RETR "+num);
    int i=0;
		try
				{
    while((s = receive()) != null) {
      
      if (s.equals(".")) {
        break;
      }
			if(s.length()>MAXMESSAGELENGTH){
					buf.append("\n(Message Truncated)\n");
					break;
			}
      buf.append(s);
      buf.append("\n");
      i++;
      //if(i>200) break;
    }
				}catch(java.lang.OutOfMemoryError e){
						buf.append("\n(Message Truncated - out of memory)\n");
				}
    return buf.toString();
    
  }

  
  public void deleteMessage(int num) throws IOException {
    
    StringBuffer buf = new StringBuffer();
    send("DELE "+num);
    receive();
    
  }

  

  public String getUidl(int num) throws IOException {
    
    String s;

    send( "UIDL "+num);
    s = receive();
    // should get something of the form
    // +OK num uidl
    String start="+OK "+num;
    if(s.indexOf(start)!=0){
      return null;
    }
    return s.substring(start.length()).trim();
     
    
    }

  public static String input(String prompt)
  {
    System.out.print(prompt);
    try{
      StringBuffer buffy=new StringBuffer();
      do {
        char typed=(char)System.in.read();
        buffy.append(typed);
      }while(System.in.available()!=0);
      return buffy.toString();
    }catch(java.io.IOException e)
    {
      return "";
    }
    
  }
    
}
