import java.net.*;
import java.io.*;
import java.util.*;

public class sendMail {
  private Socket sock;
  private BufferedReader in;
  private BufferedWriter out;
  private boolean debug;
    
  public sendMail(String server, String domain, boolean isDebug)
  {
    debug=isDebug;
    try
    {
      sock = new Socket(server, 25);
      in  = new BufferedReader(
        new InputStreamReader(sock.getInputStream()));
      out = new BufferedWriter(
        new OutputStreamWriter(sock.getOutputStream()));

      receiveAll();

      send("EHLO "+domain);
      receiveAll();
     
    }
    catch(Exception e)
    {
      // this would be bad
      e.printStackTrace();
    }
  }
  
  public void login(String user, String pass) throws IOException{

      // authenticate
    
      send("AUTH LOGIN");
      receiveAll();
    
      String user64=base64encode(user);
      send (user64);
      receiveAll();

      String pass64=base64encode(pass);
    
      send (pass64);

      receive();
  }

	public void sendMessage(Reader msg) throws IOException{
    	LineNumberReader i=new LineNumberReader(msg);
    	String line;
    	String to=null;
    	String from=null;
    	
    	// first let's find who we're from and to
    	i.mark(1024*1024);
    	
    	while(true){
    		line=i.readLine();
    		if(line==null) break;
    		line=line.trim();
    		if(line.length()==0) break;
    		int colon=line.indexOf(":");
    		String key=line.substring(0,colon);
    		key=key.trim();
    		if(key.equalsIgnoreCase("To")) to=line.substring(colon+1).trim();
    		if(key.equalsIgnoreCase("From")) from=line.substring(colon+1).trim();
    		if(to!=null && from!=null) break;
			}
			i.reset();

      send("mail from:"+from);
      receive();
      send ("rcpt to:"+to);
      receive();
      send("data");
      receive();
     	
    	line=i.readLine();
    	while(line!=null){
    		if(line.equals(".")) break;
    		send(line);
    		line=i.readLine();
    	}
    	send(".");
      receive();
   }
  public static void main(String args[]) {
    //
    //  sendMail mailServer domain [user] [password]
    //
    if(args.length!=2 && args.length!=4){
    	System.out.println("Usage: sendMail mailserver domain [user password]");
    	System.exit(0);
    }
    try {
      sendMail mailer = new sendMail(args[0],args[1],true);
      if(args.length>2) mailer.login(args[2],args[3]);
      InputStreamReader isr=new InputStreamReader(System.in);
      mailer.sendMessage(isr);
      
      mailer.quit();
        
    }
    catch (Exception e) {
      e.printStackTrace();
     }
    }

  private void send(String s) throws IOException {
    if(debug)
    {
        System.err.println("Sent:"+s);
    }
    out.write(s+"\r\n");
    out.flush();
  }

  private String receive() throws IOException {
    String line = null;
    /*
    if(!in.ready()) {
    	// wait a second for a response
    	try{
	    	Thread.sleep(1000);
	    }catch (InterruptedException e){}
    }
    if(in.ready()) line = in.readLine();
    */
    line=in.readLine();
    if(debug)
    {
      System.err.println("Recieved:"+line);
    }
    return line;
  }

 private void receiveAll() throws IOException
 {
  if(!in.ready()) {
    	// wait a second for a response
    	try{
	    	Thread.sleep(1000);
	    }catch (InterruptedException e){}
    }
  while(in.ready())
  {
    receive();
  }
 }
 

  public void quit() throws IOException
  {
    send("QUIT");
    receive();
  }
 

  public String base64encode(String in)
  {
    byte [] bytes = new byte[in.length()];
    for(int x=0;x<bytes.length;x++)
    {
      bytes[x]=(byte)in.charAt(x);
    }
    return new String(Base64.encode(bytes));
  }
 
    
}
